package joyfill.table.internal

import cinematic.mutableLiveOf
import joyfill.ChangeEvent
import joyfill.Document
import joyfill.Invalid
import joyfill.Valid
import joyfill.editors.internal.TableFieldEditorImpl
import joyfill.fields.table.NumberColumn
import joyfill.fields.table.Row
import joyfill.table.NumberCellEditor

internal class NumberCellEditorImpl(
    document: Document,
    private val table: TableFieldEditorImpl,
    override val column: NumberColumn,
    override val row: Row,
    onChange: ((ChangeEvent) -> Unit)?
) : AbstractCellEditor(document, table, onChange), NumberCellEditor {

    override val number by lazy { mutableLiveOf(row.cells[column.id] as? Double) }

    override fun set(value: Double?) {
        number.value = value
        row.cells[column.id] = value
        validity.value = when {
            column.required && value == null -> Invalid.default
            else -> Valid.default
        }
        notifyChange(field.value.map { it.toMap() }.toMutableList())
    }

    override fun doesNotHaveValue(): Boolean = row.cells[column.id]?.toString()?.toDoubleOrNull() == null
}