package joyfill.table.internal

import cinematic.mutableLiveOf
import joyfill.ChangeEvent
import joyfill.Document
import joyfill.editors.internal.TableFieldEditorImpl
import joyfill.fields.table.DateColumn
import joyfill.fields.table.Row
import joyfill.table.DateCellEditor

internal class DateCellEditorImpl(
    document: Document,
    table: TableFieldEditorImpl,
    override val column: DateColumn,
    override val row: Row,
    onChange: ((ChangeEvent) -> Unit)?
): AbstractCellEditor(document, table, onChange), DateCellEditor {

    override val date by lazy { mutableLiveOf(row.cells[column.id] as? Long) }

    override fun set(value: Long?) {
        date.value = value
        row.cells[column.id] = value
        validate()
        notifyChange(field.value.map { it.toMap() }.toMutableList())
    }

    override fun doesNotHaveValue(): Boolean = row.cells[column.id]?.toString()?.toLongOrNull() == null
}