package joyfill.table

data class RowState(
    val selected: List<RowEditor>,
    val filtered: List<RowEditor>?,
    val haystack: List<RowEditor>
) {
    fun selection(): Selection = when {
        haystack.isEmpty() -> Selection.None
        selected.size == haystack.size -> Selection.All
        selected.isEmpty() -> Selection.None
        selected.isNotEmpty() -> Selection.Some(selected)
        else -> Selection.None
    }

    fun displaying() = when (filtered) {
        null -> haystack
        else -> filtered
    }
}