package joyfill.editors.internal

import joyfill.ChangeEvent
import joyfill.Document
import joyfill.EventDispatcher
import joyfill.collections.PageCollection
import joyfill.editors.DateFieldEditor
import joyfill.fields.DateField
import kotlinx.datetime.LocalDate

@PublishedApi
internal class DateFieldEditorImpl(
    document: Document,
    override val field: DateField,
    pages: PageCollection,
    onChange: ((ChangeEvent) -> Unit)?,
    dispatcher: EventDispatcher
) : AbstractValueBasedFieldEditor<Long, DateField>(document, field, onChange, dispatcher, pages), DateFieldEditor {
    override fun setDate(year: Int, month: Int, day: Int) {
        value = LocalDate(year,month,day).toEpochDays().toLong()
    }
}