package joyfill.collections

import cinematic.Live
import joyfill.Page
import joyfill.editors.PageEditor

interface PageCollection {

    val state: Live<PageCollectionState>

    fun raw() : List<Page>

    fun all(): List<PageEditor>
    /**
     * @param key "A Key can be either an id of the page, or the name of the page"
     * @throws IllegalArgumentException if the key is not found
     */
    fun find(key: String?): PageEditor?
    fun at(index: Int): PageEditor?

    fun show(key: String?): Page?
    fun hide(key: String?): Page?
    fun setHidden(key: String?, value: Boolean): Page?

    fun navigate(page: String?): Page?
    fun navigate(page: Page?): Page?
}