package joyfill.table.internal

import cinematic.mutableLiveOf
import joyfill.ChangeEvent
import joyfill.Document
import joyfill.editors.internal.TableFieldEditorImpl
import joyfill.fields.table.Row
import joyfill.fields.table.SignatureColumn
import joyfill.table.SignatureCellEditor

internal class SignatureCellEditorImpl(
    document: Document,
    table: TableFieldEditorImpl,
    override val column: SignatureColumn,
    override val row: Row,
    onChange: ((ChangeEvent) -> Unit)?
) : AbstractCellEditor(document, table, onChange), SignatureCellEditor {

    override val signature by lazy { mutableLiveOf(row.cells[column.id] as? String) }

    override fun set(value: String?) {
        signature.value = value
        row.cells[column.id] = value
        validate()
        notifyChange(field.value.map { it.toMap() }.toMutableList())
    }

    override fun doesNotHaveValue(): Boolean {
        val value = row.cells[column.id] as? String ?: return true
        return value.isBlank()
    }
}