package joyfill.table

import joyfill.Invalid
import joyfill.Valid
import joyfill.Validation
import joyfill.fields.table.Column

data class ColumnState(
    val current: ColumnFilter?,
    val filters: List<ColumnFilter>,
    val validity: Map<CellEditor, Validation>
) {
    fun isFiltered(c: Column?): Boolean = when (val filter = filters.find { it.column.id == c?.id }) {
        is ColumnFilter.TextColumnFilter -> !filter.value.isNullOrBlank() || filter.sort != SortingOption.None
        is ColumnFilter.NumberColumnFilter -> filter.value != null || filter.sort != SortingOption.None
        is ColumnFilter.DropdownColumnFilter -> filter.value != null || filter.sort != SortingOption.None
        is ColumnFilter.MultiselectColumnFilter -> filter.value != null || filter.sort != SortingOption.None
        is ColumnFilter.BarcodeColumnFilter -> !filter.value.isNullOrBlank() || filter.sort != SortingOption.None
        else -> false
    }

    internal fun copy(cell: CellEditor, validation: Validation) = copy(validity = validity + (cell to validation))

    fun validity(column: Column): Validation {
        validity.filterKeys { it.column.id == column.id }.forEach { (_, value) ->
            if (value is Invalid) {
                return value
            }
        }
        return Valid.default
    }
}