package joyfill.editors.internal

import joyfill.ChangeEvent
import joyfill.Document
import joyfill.EventDispatcher
import joyfill.IdentityGenerator
import joyfill.collections.PageCollection
import joyfill.editors.FileBasedFieldEditor
import joyfill.fields.ListBasedField
import joyfill.utils.Attachment
import joyfill.utils.ID
import joyfill.utils.toAttachment

@PublishedApi
internal abstract class AbstractFileBasedFieldEditor(
    document: Document,
    override val field: ListBasedField<Attachment>,
    private val identity: IdentityGenerator,
    pages: PageCollection,
    dispatcher: EventDispatcher,
    onChange: ((ChangeEvent) -> Unit)?
) : AbstractListBasedFieldEditor<Attachment>(document, field, pages, dispatcher, onChange), FileBasedFieldEditor {

    override fun add(url: String) = add(listOf(url))

    override fun add(urls: List<String>) {
        val attachments = urls.map {
            mutableMapOf<String, Any?>(
                ID to identity.generate(),
                Attachment::url.name to it
            ).toAttachment()
        }.toMutableList()
        value.addAll(attachments)
    }

    override fun set(urls: List<String>) {
        val attachments = urls.map {
            mutableMapOf<String, Any?>(
                ID to identity.generate(),
                Attachment::url.name to it
            ).toAttachment()
        }.toMutableList()
        field.value.clear()
        value.addAll(attachments)
    }

    override fun remove(key: String?) {
        if (key == null) return
        remove(listOf(key))
    }

    override fun remove(keys: List<String>) {
        val found = field.value.filter { it.id in keys || it.url in keys || it.fileName in keys }
        if (found.isEmpty()) return
        value.removeAll(found)
    }
}