package joyfill.table.internal

import cinematic.mutableLiveOf
import joyfill.ChangeEvent
import joyfill.Document
import joyfill.Invalid
import joyfill.Valid
import joyfill.editors.internal.EventTrigger
import joyfill.editors.internal.TableFieldEditorImpl
import joyfill.fields.TableField
import joyfill.table.CellEditor

internal abstract class AbstractCellEditor(
    document: Document,
    private val table: TableFieldEditorImpl,
    onChange: ((ChangeEvent) -> Unit)?
) : EventTrigger<TableField>(document, table.field, onChange), CellEditor {

    override val validity by lazy {
        val value = when {
            column.required && doesNotHaveValue() -> Invalid.default
            else -> Valid.default
        }
        mutableLiveOf(value)
    }

    abstract fun doesNotHaveValue(): Boolean

    override fun validate() {
        val validation = when {
            column.required && doesNotHaveValue() -> Invalid.default
            else -> Valid.default
        }
        validity.value = validation
        val columns = table.columns.state.value.copy(this, validation)
        table.columns.state.value = columns
    }
}