package joyfill.table

import joyfill.fields.table.Row

interface RowEditor {
    val row: Row
    fun text(key: String?): TextCellEditor?
    fun text(index: Int): TextCellEditor?

    fun date(key: String): DateCellEditor?
    fun date(index: Int): DateCellEditor?

    fun blockText(key: String): BlockCellEditor?
    fun blockText(index: Int): BlockCellEditor?

    fun progress(key: String): ProgressCellEditor?
    fun progress(index: Int): ProgressCellEditor?

    fun number(key: String): NumberCellEditor?
    fun number(index: Int): NumberCellEditor?

    fun image(key: String?): ImageCellEditor?
    fun image(index: Int): ImageCellEditor?

    fun barcode(key: String?): BarcodeCellEditor?
    fun barcode(index: Int): BarcodeCellEditor?

    fun signature(key: String?): SignatureCellEditor?
    fun signature(index: Int): SignatureCellEditor?

    fun dropdown(key: String?): DropdownCellEditor?
    fun dropdown(index: Int): DropdownCellEditor?

    fun multiSelect(key: String?): MultiselectCellEditor?
    fun multiSelect(index: Int): MultiselectCellEditor?

    fun col(key: String?): CellEditor?
    fun col(index: Int): CellEditor?

    fun copyInto(other: RowEditor)
}