package joyfill.table.internal

import cinematic.mutableLiveOf
import joyfill.ChangeEvent
import joyfill.Document
import joyfill.editors.internal.TableFieldEditorImpl
import joyfill.fields.table.ProgressColumn
import joyfill.fields.table.Row
import joyfill.table.ProgressCellEditor

internal class ProgressCellEditorImpl(
    document: Document,
    table: TableFieldEditorImpl,
    override val column: ProgressColumn,
    override val row: Row,
    onChange: ((ChangeEvent) -> Unit)?
): AbstractCellEditor(document, table, onChange), ProgressCellEditor {

    override val progress by lazy { mutableLiveOf(row.cells[column.id] as? Int) }

    override fun set(value: Int?) {
        progress.value = value
        row.cells[column.id] = value
        notifyChange(field.value.map { it.toMap() }.toMutableList())
    }

    override fun doesNotHaveValue(): Boolean = false
}