package joyfill.editors.internal

import cinematic.mutableLiveOf
import joyfill.editors.AxisEditor
import joyfill.fields.chart.Axis

internal class AxisEditorImpl(override val axis: Axis) : AxisEditor {
    override val label by lazy { mutableLiveOf(axis.label) }
    override val min by lazy { mutableLiveOf(axis.min) }
    override val max by lazy { mutableLiveOf(axis.max) }

    override fun label(value: String) {
        label.value = value
        axis.label = value
    }

    override fun min(value: Double?) {
        val v = value ?: return
        axis.min = v
        min.value = v
    }

    override fun max(value: Double?) {
        val v = value ?: return
        axis.max = v
        max.value = v
    }
}