package joyfill.chart.internal

import joyfill.IdentityGenerator
import joyfill.chart.LineEditor
import joyfill.chart.PointEditor
import joyfill.fields.chart.Line
import joyfill.fields.chart.Point
import joyfill.toPoint
import joyfill.utils.ID

@PublishedApi
internal class LineEditorImpl(
    private val identity: IdentityGenerator,
    override val line: Line
) : LineEditor {
    override fun title(value: String) {
        line.title = value
    }

    override fun title() = line.title

    override fun description(value: String?) {
        line.description = value
    }

    override fun description() = line.description

    override fun points(): List<PointEditor> = line.points.map {
        PointEditorImpl(it)
    }

    private fun look(key: String): Point? = line.points.find { it.id == key || it.label == key }

    override fun find(key: String): PointEditor? {
        val point = look(key) ?: return null
        return PointEditorImpl(point)
    }

    override fun point(p: Point): PointEditor {
        return PointEditorImpl(p)
    }

    override fun add(): PointEditor {
        val point = mutableMapOf<String, Any?>(
            ID to identity.generate(),
            Point::label.name to "Point ${line.points.size + 1}",
            Point::x.name to 0.0,
            Point::y.name to 0.0
        ).toPoint()
        line.points.add(point)
        return PointEditorImpl(point)
    }

    override fun remove(key: String): Point? {
        val point = look(key) ?: return null
        line.points.remove(point)
        return point
    }
}