package joyfill.collections

import joyfill.Page
import joyfill.editors.BarcodeFieldEditor
import joyfill.editors.ChartFieldEditor
import joyfill.editors.DateFieldEditor
import joyfill.editors.DropdownFieldEditor
import joyfill.editors.FieldEditor
import joyfill.editors.FileFieldEditor
import joyfill.editors.ImageFieldEditor
import joyfill.editors.MultiSelectFieldEditor
import joyfill.editors.NumberFieldEditor
import joyfill.editors.SignatureFieldEditor
import joyfill.editors.TableFieldEditor
import joyfill.editors.TextAreaFieldEditor
import joyfill.editors.TextFieldEditor

interface FieldCollection {

    fun all(): List<FieldEditor>

    fun from(page: String): List<FieldEditor>

    fun from(page: Page): List<FieldEditor>

    fun find(key: String): FieldEditor?

    fun text(key: String): TextFieldEditor?

    fun textarea(key: String): TextAreaFieldEditor?

    fun signature(key: String): SignatureFieldEditor?

    fun number(key: String): NumberFieldEditor?

    fun date(key: String): DateFieldEditor?

    fun dropdown(key: String): DropdownFieldEditor?

    fun select(key: String): MultiSelectFieldEditor?

    fun image(key: String): ImageFieldEditor?

    fun file(key: String): FileFieldEditor?

    fun barcode(key: String): BarcodeFieldEditor?

    fun table(key: String): TableFieldEditor?

    fun chart(key: String): ChartFieldEditor?
}