package joyfill.utils

import androidx.compose.runtime.Composable
import androidx.compose.runtime.LaunchedEffect
import androidx.compose.runtime.MutableState
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.remember
import joyfill.editors.ValueBasedFieldEditor
import kotlin.time.Duration.Companion.seconds
import kotlinx.coroutines.Job
import kotlinx.coroutines.delay
import kotlinx.coroutines.launch

@Composable
internal fun <T> ValueBasedFieldEditor<T>.rememberAutoCleaner(value: T?): MutableState<Boolean> {
    val clean = remember { mutableStateOf(true) }
    var job: Job? = null
    LaunchedEffect(clean.value, value) {
        if (clean.value) return@LaunchedEffect
        job?.cancel()
        job = launch {
            delay(1.seconds)
            this@rememberAutoCleaner.value = value
            clean.value = true
        }
    }
    return clean
}