package joyfill.utils

import krono.Instant
import krono.PureDateTimeFormatter

fun String.requiresDate() = listOf("YY", "MM", "DD").any { contains(it) }

fun String.requiresTime() = listOf("hh", "mm").any { contains(it) }

fun String?.replaceHolders() = this?.replace("YYYY", "{YYYY}")
    ?.replace("MM", "{MM}")
    ?.replace("DD", "{DD}")
    ?.replace("hh", "{hh}")
    ?.replace("mm", "{mm}")
    ?.replace("a", "{ampm}")

//- **Formats**
//- `MM/DD/YYYY` - this format specifies that only date is displayed and selectable.
//- `MM/DD/YYYY hh:mma` - (Default) this format specifies that date and time should be displayed and selectable.
//- `hh:mma` - this format specifies that only time is displayed and selectable.

fun String.format(date: Long?, hr: Int?, min: Int?): String {
    val formatter = PureDateTimeFormatter(this)
    if (date != null) {
        val zdt = Instant(date).atZone("UTC")
        return formatter.formatDateTime(zdt.year, zdt.monthNumber, zdt.dayOfMonth, hr ?: 0, min ?: 0, 0)
    }
    if (requiresDate()) {
        return ""
    }

    if (requiresTime() && hr == null) {
        return ""
    }

    return formatter.formatDateTime(0, 1, 1, hr ?: 0, min ?: 0, 0)
}