package joyfill.table

import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.height
import androidx.compose.foundation.layout.offset
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.width
import androidx.compose.material3.Icon
import androidx.compose.material3.LocalContentColor
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.draw.scale
import androidx.compose.ui.unit.dp
import androidx.compose.ui.unit.sp
import joyfill.table.icons.rememberArrowDownIcon
import joyfill.table.icons.rememberArrowUpIcon

@Composable
internal fun SortView(
    option: SortingOption,
    modifier: Modifier = Modifier,
) = Row(modifier, verticalAlignment = Alignment.CenterVertically) {
    Text("Sort", modifier = Modifier.padding(start = dx.dp * 2), fontSize = 18.sp)
    Spacer(modifier = Modifier.width(dx.dp))
    Arrows(option)
}

private val size = 30.dp

private const val dx = 4
private fun Modifier.arrow() = height(size).scale(0.8f)
private fun Modifier.arrowLeft() = arrow().offset(x = (dx).dp)
private fun Modifier.arrowRight() = arrow().offset(x = (-dx).dp)

@Composable
private fun Arrows(option: SortingOption) = Row {
    when (option) {
        SortingOption.None -> {
            val color = LocalContentColor.current.copy(alpha = 0.6f)
            Icon(painter = rememberArrowUpIcon(color), "Arrow Up", modifier = Modifier.arrowLeft())
            Icon(painter = rememberArrowDownIcon(color), "Arrow Up", modifier = Modifier.arrowRight())
        }

        SortingOption.Ascending -> {
            val color = LocalContentColor.current
            val painter = rememberArrowUpIcon(color)
            Icon(painter, "Ascending", modifier = Modifier.arrowLeft())
            Icon(painter, "Ascending", modifier = Modifier.arrowRight())
        }

        SortingOption.Descending -> {
            val color = LocalContentColor.current
            val painter = rememberArrowDownIcon(color)
            Icon(painter, "Descending", modifier = Modifier.arrowLeft())
            Icon(painter, "Descending", modifier = Modifier.arrowRight())
        }
    }
}