package joyfill.image

import androidx.compose.animation.AnimatedVisibility
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.height
import androidx.compose.runtime.Composable
import androidx.compose.runtime.remember
import androidx.compose.ui.Modifier
import androidx.compose.ui.unit.dp
import cinematic.watchAsState
import joyfill.JoyFieldHead
import joyfill.Mode
import joyfill.Signal
import joyfill.editors.ImageFieldEditor
import joyfill.utils.Attachment

@Composable
internal fun JoyImageField(
    editor: ImageFieldEditor,
    mode: Mode,
    onUpload: (suspend () -> List<String>)? = null,
    onSignal: (Signal<List<Attachment>>) -> Unit,
) = AnimatedVisibility(visible = !editor.hidden.watchAsState()) {
    val field = remember(editor) { editor.field }
    Column(modifier = Modifier.fillMaxWidth()) {
        JoyFieldHead(field)
        Spacer(modifier = Modifier.height(4.dp))
        RawImageField(
            id = field.id,
            title = field.title,
            uploaded = editor.value,
            readonly = field.disabled || mode == Mode.readonly,
            onUpload = onUpload,
            onDialog = { opened ->

            },
            onAdded = {
                editor.add(it)
                onSignal(Signal.Change(field.value))
            },
            onRemoved = {
                editor.remove(it)
                onSignal(Signal.Change(field.value))
            },
            preview = { params ->
                FirstImagePreview(
                    id = field.id,
                    params = params,
                    onFocus = {
                        onSignal(if (it.hasFocus) Signal.Focus else Signal.Blur(Unit))
                    },
                    onRemove = {
                        editor.remove(it)
                        onSignal(Signal.Change(field.value))
                    }
                )
            }
        )
    }
}