package joyfill

import androidx.compose.material3.LocalTextStyle
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.text.AnnotatedString
import androidx.compose.ui.text.SpanStyle
import androidx.compose.ui.text.buildAnnotatedString
import androidx.compose.ui.text.font.FontWeight
import androidx.compose.ui.text.withStyle
import joyfill.fields.Field

@Composable
internal fun JoyTitle(
    field: Field,
    asterisk: Boolean = field.required,
    modifier: Modifier = Modifier
) = JoyTitle(
    modifier = modifier,
    title = buildAnnotatedString {
        append(field.title)
        if (asterisk) withStyle(
            SpanStyle(
                color = MaterialTheme.colorScheme.error,
                fontWeight = FontWeight.ExtraBold,
                fontSize = LocalTextStyle.current.fontSize * 1.5,
            )
        ) {
            append(" *")
        }
    }
)

@Composable
internal fun JoyRawTitle(
    title: String,
    required: Boolean ,
    modifier: Modifier = Modifier
) = JoyTitle(
    modifier = modifier,
    title = buildAnnotatedString {
        append(title)
        if (required) withStyle(
            SpanStyle(
                color = MaterialTheme.colorScheme.error,
                fontWeight = FontWeight.ExtraBold,
                fontSize = LocalTextStyle.current.fontSize * 1.5,
            )
        ) {
            append(" *")
        }
    }
)

@Composable
internal fun JoyTitle(
    title: String,
    modifier: Modifier = Modifier
) = JoyTitle(title = buildAnnotatedString { append(title) }, modifier)

@Composable
internal fun JoyTitle(
    title: AnnotatedString,
    modifier: Modifier = Modifier
) = Text(title, modifier = modifier, fontWeight = FontWeight.SemiBold)