package joyfill.table.icons

import androidx.compose.runtime.Composable
import androidx.compose.runtime.remember
import androidx.compose.ui.graphics.Brush
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.PathParser
import androidx.compose.ui.graphics.vector.VectorPainter
import androidx.compose.ui.graphics.vector.rememberVectorPainter
import androidx.compose.ui.unit.dp

private const val data = "M182.6,41.4c-12.5,-12.5 -32.8,-12.5 -45.3,0l-96,96c-12.5,12.5 -12.5,32.8 0,45.3s32.8,12.5 45.3,0L128,141.3 128,448c0,17.7 14.3,32 32,32s32,-14.3 32,-32l0,-306.7 41.4,41.4c12.5,12.5 32.8,12.5 45.3,0s12.5,-32.8 0,-45.3l-96,-96zM534.6,374.7c12.5,-12.5 12.5,-32.8 0,-45.3s-32.8,-12.5 -45.3,0L448,370.7 448,64c0,-17.7 -14.3,-32 -32,-32s-32,14.3 -32,32l0,306.7 -41.4,-41.4c-12.5,-12.5 -32.8,-12.5 -45.3,0s-12.5,32.8 0,45.3l96,96c12.5,12.5 32.8,12.5 45.3,0l96,-96z"

private val nodes by lazy { PathParser().parsePathString(data).toNodes() }

@Composable
internal fun rememberArrowUpArrowDownIcon(
    color: Color = Color.Black
) = rememberArrowUpArrowDownIcon(SolidColor(color))

@Composable
internal fun rememberArrowUpArrowDownIcon(
    brush: Brush
): VectorPainter {
    val vector = remember(brush) {
        ImageVector.Builder(
            name = "arrow up arrow down",
            defaultWidth = 576.dp,
            defaultHeight = 512.dp,
            viewportWidth = 576f,
            viewportHeight = 512f,
        ).addPath(nodes, fill = brush).build()
    }
    return rememberVectorPainter(vector)
}