package joyfill.table

import androidx.compose.ui.text.TextMeasurer
import androidx.compose.ui.unit.Dp
import androidx.compose.ui.unit.dp
import joyfill.fields.Field

internal fun colWidth(type: Field.Type, preview: Boolean, measurer: TextMeasurer? = null, text:String? = null): Dp = when (type) {
    Field.Type.text -> 150.dp
    Field.Type.number -> 150.dp
    Field.Type.block -> if(text == null) 150.dp else measurer?.measure(text)?.size?.width?.dp ?: 150.dp
    Field.Type.progress -> 150.dp
    Field.Type.multiSelect -> 150.dp
    Field.Type.date -> (measurer?.measure(text ?: "12/13/2024 05:29 pm")?.size?.width?.dp ?: 280.dp) - 40.dp
    Field.Type.dropdown -> 200.dp
    Field.Type.image -> if (preview) 100.dp else 200.dp
    Field.Type.barcode -> 200.dp
    Field.Type.signature -> 150.dp
    else -> 100.dp
}