package joyfill.shared

import androidx.compose.foundation.text.KeyboardOptions
import androidx.compose.material3.LocalContentColor
import androidx.compose.material3.OutlinedTextField
import androidx.compose.material3.OutlinedTextFieldDefaults
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.remember
import androidx.compose.runtime.setValue
import androidx.compose.ui.Modifier
import androidx.compose.ui.focus.FocusState
import androidx.compose.ui.focus.onFocusChanged
import androidx.compose.ui.graphics.Color
import joyfill.fields.Field
import joyfill.isValidNumber

@Composable
internal fun RawInputField(
    value: String?,
    placeholder: String? = null,
    borders: Boolean = true,
    modifier: Modifier = Modifier.Companion,
    onChange: (String) -> Unit,
    maxLines: Int = Int.MAX_VALUE,
    readonly: Boolean = false,
    keyboard: KeyboardOptions = KeyboardOptions.Companion.Default,
    minLines: Int = 1,
    onFocusChanged: (FocusState) -> Unit,
    columnType: Field.Type = Field.Type.text,
) {
    var v by remember(value) { mutableStateOf(value ?: "") }
    OutlinedTextField(
        value = v,
        onValueChange = {
            if(columnType == Field.Type.number && !it.isValidNumber()) return@OutlinedTextField
            v = it
            onChange(it)
        },
        readOnly = readonly,
        modifier = modifier.onFocusChanged(onFocusChanged),
        singleLine = maxLines == 1,
        maxLines = maxLines,
        placeholder = {
            if (placeholder != null) Text(
                placeholder,
                color = LocalContentColor.current.copy(alpha = 0.6f)
            )
        },
        keyboardOptions = keyboard,
        minLines = minLines,
        colors = if (borders) {
            OutlinedTextFieldDefaults.colors()
        } else {
            OutlinedTextFieldDefaults.colors(
                focusedBorderColor = Color.Companion.Transparent,
                unfocusedBorderColor = Color.Companion.Transparent,
            )
        }
    )
}