package joyfill.image

import androidx.compose.foundation.Image
import androidx.compose.foundation.clickable
import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.foundation.layout.padding
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.text.style.TextAlign
import androidx.compose.ui.unit.dp
import joyfill.legacy_compose.generated.resources.Res
import joyfill.legacy_compose.generated.resources.image64
import org.jetbrains.compose.resources.painterResource

@Composable
internal fun ImageCountPreview(
    count: Int,
    modifier: Modifier,
    onClick: () -> Unit
) {
    Row(
        verticalAlignment = Alignment.CenterVertically,
        horizontalArrangement = Arrangement.Center,
        modifier = modifier
            .fillMaxSize()
            .clickable { onClick() }
    ) {
        Image(
            painter = painterResource(Res.drawable.image64),
            contentDescription = null,
            modifier = Modifier
                .padding(8.dp)
        )

        if (count > 0) {
            Text(
                text = "+$count",
                textAlign = TextAlign.Center,
                modifier = Modifier
                    .padding(end = 8.dp)
                    .padding(vertical = 8.dp)
            )
        }
    }
}