@file:OptIn(ExperimentalComposeUiApi::class)

package joyfill.utils

import androidx.compose.ui.ExperimentalComposeUiApi
import androidx.compose.ui.Modifier
import androidx.compose.ui.geometry.Offset
import androidx.compose.ui.input.pointer.PointerEventType
import androidx.compose.ui.input.pointer.onPointerEvent

internal actual fun Modifier.onDrawing(
    started: () -> Unit,
    ended: () -> Unit,
    progressing: (Offset) -> Unit,
): Modifier = onPointerEvent(PointerEventType.Press) {
    started()
}.onPointerEvent(PointerEventType.Release) {
    ended()
}.onPointerEvent(PointerEventType.Move) { event ->
    event.changes.forEach { progressing(it.position) }
}