package joyfill.table

import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.size
import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.filled.Check
import androidx.compose.material3.CircularProgressIndicator
import androidx.compose.material3.Icon
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.vector.rememberVectorPainter
import androidx.compose.ui.unit.Dp
import androidx.compose.ui.unit.dp

@Composable
internal fun JoyProgressCell(totalCells: Int, validCells: Int, progressSize: Dp = 36.dp, modifier: Modifier = Modifier.fillMaxWidth()) {
    val progress = validCells.toFloat() / totalCells
    Row(
        verticalAlignment = Alignment.CenterVertically,
        horizontalArrangement = Arrangement.Center,
        modifier = modifier
    ) {
        if (totalCells == validCells) {
            Icon(
                painter = rememberVectorPainter(Icons.Filled.Check),
                contentDescription = "Complete"
            )
        } else {
            CircularProgressIndicator(
                progress = { progress },
                modifier = Modifier.size(progressSize).padding(vertical = 8.dp).padding(end = 8.dp)
            )
        }
    }
}