package joyfill.image

import androidx.compose.foundation.background
import androidx.compose.foundation.clickable
import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.width
import androidx.compose.foundation.shape.RoundedCornerShape
import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.filled.Backup
import androidx.compose.material3.Icon
import androidx.compose.material3.LocalContentColor
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.unit.dp

@Composable
internal fun UploadLabel(
    modifier: Modifier = Modifier,
    onClick: () -> Unit,
) = Row(
    verticalAlignment = Alignment.CenterVertically,
    horizontalArrangement = Arrangement.Center,
    modifier = Modifier
        .dashedBorder(
            width = 2.dp,
            radius = 8.dp,
            color = LocalContentColor.current
        )
        .padding(4.dp)
        .background(color = LocalContentColor.current.copy(alpha = 0.2f), RoundedCornerShape(8.dp))
        .then(modifier)
        .clickable { onClick() }
) {
    Text("Upload")
    Spacer(modifier = Modifier.width(4.dp))
    Icon(Icons.Filled.Backup, "Upload icon")
}