package joyfill.image

import androidx.compose.foundation.background
import androidx.compose.foundation.border
import androidx.compose.foundation.clickable
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.heightIn
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.size
import androidx.compose.foundation.shape.RoundedCornerShape
import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.filled.Check
import androidx.compose.material.icons.filled.Delete
import androidx.compose.material3.Icon
import androidx.compose.material3.LocalContentColor
import androidx.compose.material3.MaterialTheme
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.draw.clip
import androidx.compose.ui.unit.Dp
import androidx.compose.ui.unit.dp
import joyfill.Image

@Composable
internal fun Picture(
    url: String,
    selected: Boolean,
    onSelectorClicked: ((String) -> Unit)? = null,
    onDelete: ((String) -> Unit)? = null,
    margin: Dp = 0.dp,
    modifier: Modifier = Modifier,
) = Box(
    modifier = Modifier.fillMaxWidth()
        .padding(margin)
        .border(
            width = 2.dp,
            color = LocalContentColor.current.copy(alpha = 0.2f),
            shape = RoundedCornerShape(8.dp)
        ).padding(4.dp)
        .then(modifier)
) {
    Image(url, url, modifier = Modifier.fillMaxWidth().heightIn(200.dp, 400.dp).clip(RoundedCornerShape(8.dp)))
    if (onSelectorClicked != null) Box(
        modifier = Modifier
            .padding(top = 4.dp, end = 4.dp)
            .clip(RoundedCornerShape(15.dp))
            .size(24.dp)
            .align(Alignment.TopEnd).clickable { onSelectorClicked(url) }
            .border(
                width = 2.dp,
                color = LocalContentColor.current.copy(alpha = 0.5f),
                shape = RoundedCornerShape(12.dp)
            ).background(color = MaterialTheme.colorScheme.surface.copy(alpha = 0.5f))
    ) {
        if (selected) Icon(
            imageVector = Icons.Filled.Check,
            contentDescription = "select picture",
            modifier = Modifier.align(Alignment.Center),
        )
    }

    if (onDelete != null) Box(
        modifier = modifier
            .padding(top = 4.dp, end = 4.dp)
            .align(Alignment.TopEnd).clickable { onDelete(url) }
    ) {
        Icon(Icons.Filled.Delete, "select picture", modifier = Modifier.align(Alignment.Center))
    }
}