package joyfill.table

import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.text.BasicTextField
import androidx.compose.foundation.text.input.TextFieldState
import androidx.compose.material3.LocalContentColor
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.runtime.remember
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.input.key.onKeyEvent
import androidx.compose.ui.text.TextStyle
import androidx.compose.ui.text.font.FontWeight
import androidx.compose.ui.unit.dp
import androidx.compose.ui.unit.sp

@Composable
internal fun SearchTextInput(
    value: String?,
    modifier: Modifier = Modifier,
    onChange: (String) -> Unit,
) {
    val color = LocalContentColor.current
    val state = remember(value) { TextFieldState(initialText = value ?: "") }
    BasicTextField(
        state = state,
        modifier = modifier.onKeyEvent {
            onChange(state.text.toString())
            false
        },
        cursorBrush = SolidColor(color),
        textStyle = TextStyle(color, fontSize = 18.sp, fontWeight = FontWeight.W300),
        decorator = {
            Box(
                modifier = Modifier.padding(8.dp),
                contentAlignment = Alignment.CenterStart
            ) {
                if (state.text.isEmpty()) Text("Search...", color = color.copy(alpha = 0.6f))
                it()
            }
        }
    )
}