package joyfill.table

import androidx.compose.foundation.Image
import androidx.compose.foundation.border
import androidx.compose.foundation.clickable
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.foundation.layout.heightIn
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.shape.RoundedCornerShape
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.TextFieldDefaults
import androidx.compose.runtime.Composable
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.remember
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.ColorFilter
import androidx.compose.ui.platform.testTag
import androidx.compose.ui.unit.dp
import joyfill.legacy_compose.generated.resources.Res
import joyfill.legacy_compose.generated.resources.signature
import joyfill.shared.RawSignatureInput
import kotlin.io.encoding.ExperimentalEncodingApi
import org.jetbrains.compose.resources.painterResource

@OptIn(ExperimentalEncodingApi::class)
@Composable
fun JoySignatureCell(
    id: String,
    value: String?,
    modifier: Modifier = Modifier,
    onChange: (String?) -> Unit,
    readonly: Boolean = false,
    borders: Boolean = false,
) = Box(
    modifier = modifier
        .fillMaxSize()
        .heightIn(min = TextFieldDefaults.MinHeight)
        .testTag("${id}-signature-dialog")
        //.border(width = if(borders)1.dp else 0.dp, color = if(borders) Color.Unspecified else Color.Transparent),
        .border(
            width = if (borders) 1.dp else 0.dp,
            color = if (borders) MaterialTheme.colorScheme.onSurface else Color.Transparent,
            shape = RoundedCornerShape(4.dp)
        )
        .padding(4.dp)
) {
    val showDialog = remember { mutableStateOf(false) }

    if (showDialog.value) {
        RawSignatureInput(
            modifier = Modifier.fillMaxSize(),
            onCaptured = {
                onChange(it)
                showDialog.value = false
            },
            onCanceled = { showDialog.value = false },
            title = "Signature",
            required = false,
            url = value,
            testTagId = id,
        )
    } else {
        val base64 = value?.split("base64,")?.last()
        val modifier = Modifier.fillMaxSize()
            .clickable {
                if (readonly) return@clickable
                showDialog.value = !showDialog.value
            }
            //.heightIn(24.dp, 48.dp)
            .border(0.dp, Color.Transparent)
            .padding(8.dp)

        Image(
            painter = painterResource(Res.drawable.signature),
            contentDescription = "signature",
            colorFilter = if (base64?.isNotBlank() == true) ColorFilter.tint(Color.White) else null,
            modifier = modifier,
        )
    }
}
