package joyfill

import androidx.compose.animation.AnimatedVisibility
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.height
import androidx.compose.material3.OutlinedTextField
import androidx.compose.runtime.Composable
import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.remember
import androidx.compose.runtime.setValue
import androidx.compose.ui.Modifier
import androidx.compose.ui.focus.onFocusChanged
import androidx.compose.ui.platform.testTag
import androidx.compose.ui.unit.dp
import cinematic.watchAsState
import joyfill.editors.TextAreaFieldEditor
import joyfill.utils.rememberAutoCleaner

@Composable
internal fun JoyTextArea(
    editor: TextAreaFieldEditor,
    mode: Mode,
    onSignal: (Signal<String>) -> Unit
) = AnimatedVisibility(visible = !editor.hidden.watchAsState()) {
    val field = remember(editor) { editor.field }
    var value by remember { mutableStateOf(field.value ?: "") }
    val focus = remember(onSignal) { FocusManager(onSignal) { editor.value = value } }

    var clean by editor.rememberAutoCleaner(value)

    Column(modifier = Modifier.fillMaxWidth()) {
        JoyFieldHead(field)
        Spacer(modifier = Modifier.height(4.dp))
        OutlinedTextField(
            value = value,
            onValueChange = {
                value = it
                clean = false
                onSignal(Signal.Change(it))
            },
            readOnly = field.disabled || mode == Mode.readonly,
            minLines = 5,
            modifier = Modifier.testTag("${field.id}-body")
                .fillMaxWidth()
                .onFocusChanged(focus.handler)
        )
    }
}