package joyfill.common

import androidx.compose.ui.graphics.Color

/**
 * Converts a hex string to a color.
 * valid color should start with # and must be at least 7 characters long in total.
 * @return The color or null if the string is not a valid color.
 */
fun String.toColor(): Color? {
    if (this.length < 7 || !this.startsWith("#")) return null
    val r = this.substring(1, 3).toInt(16)
    val g = this.substring(3, 5).toInt(16)
    val b = this.substring(5, 7).toInt(16)
    return Color(r, g, b)
}