package joyfill

import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.text.SpanStyle
import androidx.compose.ui.text.buildAnnotatedString
import androidx.compose.ui.text.withStyle
import joyfill.fields.Field

@Composable
internal fun JoylessField(
    field: Field,
    showUnsupportedFields: Boolean
) {

    if (showUnsupportedFields) {
        val text = buildAnnotatedString {
            withStyle(SpanStyle(color = Color.Yellow)) { append("! ") }
            append(field.title)
        }
        Text(text)
    }
}