@file:OptIn(ExperimentalMaterial3Api::class)

package joyfill

import androidx.compose.foundation.clickable
import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.padding
import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.outlined.Info
import androidx.compose.material3.ExperimentalMaterial3Api
import androidx.compose.material3.Icon
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.PlainTooltip
import androidx.compose.material3.Text
import androidx.compose.material3.TooltipBox
import androidx.compose.material3.TooltipDefaults
import androidx.compose.material3.rememberTooltipState
import androidx.compose.runtime.Composable
import androidx.compose.runtime.rememberCoroutineScope
import androidx.compose.ui.Modifier
import androidx.compose.ui.text.font.FontWeight
import androidx.compose.ui.unit.DpSize
import androidx.compose.ui.unit.dp
import joyfill.fields.Field
import kotlinx.coroutines.launch

@Composable
internal fun JoyTip(field: Field) {
    val tip = field.tip
    if (!tip.visible) return
    val state = rememberTooltipState(isPersistent = true)
    val scope = rememberCoroutineScope()
    TooltipBox(
        positionProvider = TooltipDefaults.rememberPlainTooltipPositionProvider(),
        state = state,
        tooltip = {
            PlainTooltip(
                caretSize = DpSize(10.dp, 20.dp),
                containerColor = MaterialTheme.colorScheme.surfaceContainerHigh,
                contentColor = MaterialTheme.colorScheme.onSurface,
            ) {
                Column(
                    modifier = Modifier.padding(8.dp),
                    verticalArrangement = Arrangement.spacedBy(4.dp)
                ) {
                    Text(tip.title, fontWeight = FontWeight.Bold)
                    Text(tip.description)
                }
            }
        }
    ) {
        Icon(
            imageVector = Icons.Outlined.Info,
            contentDescription = tip.title,
            modifier = Modifier.clickable {
                scope.launch {
                    if (state.isVisible) {
                        state.dismiss()
                    } else {
                        state.show()
                    }
                }
            }
        )
    }
}