package joyfill

import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.platform.testTag
import joyfill.fields.Field

@Composable
internal fun JoyFieldHead(
    field: Field,
    asterisk: Boolean = field.required,
    modifier: Modifier = Modifier
) = Row(
    modifier = Modifier.fillMaxWidth(),
    horizontalArrangement = Arrangement.SpaceBetween,
    verticalAlignment = Alignment.CenterVertically
) {
    JoyTitle(field, asterisk, modifier.testTag("${field.id}-title"))
    JoyTip(field)
}