package joyfill

import androidx.compose.runtime.Composable
import androidx.compose.runtime.remember
import kotlinx.serialization.json.JsonObject

@Composable
fun rememberEditor(
    document: Document,
    identity: IdentityGenerator = IdentityGenerator.default,
    onChange: ((ChangeEvent) -> Unit)? = null
) = remember(document, identity, onChange) {
    editorOf(document, identity, onChange)
}

@Composable
fun rememberEditor(
    map: MutableMap<String, Any?>,
    identity: IdentityGenerator = IdentityGenerator.default,
    onChange: ((ChangeEvent) -> Unit)? = null
) = remember(map, identity, onChange) {
    editorOf(map, identity, onChange)
}

@Composable
fun rememberEditor(
    json: String,
    identity: IdentityGenerator = IdentityGenerator.default,
    onChange: ((ChangeEvent) -> Unit)? = null
) = remember(json, identity, onChange) {
    editorOf(json, identity, onChange)
}

@Composable
fun rememberEditor(
    json: JsonObject,
    identity: IdentityGenerator = IdentityGenerator.default,
    onChange: ((ChangeEvent) -> Unit)? = null
) = remember(json, identity, onChange) {
    editorOf(json, identity, onChange)
}