package joyfill.image

import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.PaddingValues
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.height
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.shape.RoundedCornerShape
import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.sharp.ArrowCircleRight
import androidx.compose.material3.Button
import androidx.compose.material3.Icon
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.focus.FocusState
import androidx.compose.ui.platform.testTag
import androidx.compose.ui.unit.dp
import joyfill.internal.ActiveFocusState
import joyfill.internal.InActiveFocusState

@Composable
internal fun FirstImagePreview(
    id: String,
    params: PreviewParams,
    onFocus: (FocusState) -> Unit,
    onRemove: (String) -> Unit
) = Column(modifier = Modifier.testTag("$id-preview").fillMaxWidth()) {
    when (val first = params.value.firstOrNull()) {
        null -> UploadLabel(
            modifier = Modifier.testTag("$id-preview-label").fillMaxWidth().height(200.dp),
            onClick = {
                if (params.onUpload == null || params.readonly) return@UploadLabel
                onFocus(ActiveFocusState)
                params.onUploadHandler { onFocus(InActiveFocusState) }
            }
        )

        else -> Box {
            Picture(
                url = first,
                selected = params.selected.contains(first),
                onDelete = { url: String ->
                    params.value.remove(url)
                    onRemove(url)
                    if (params.value.size == 0) {
                        params.setModalState(false)
                    }
                }.takeIf { !params.readonly },
                modifier = Modifier.testTag("$id-preview-picture-$first")
            )
            Button(
                onClick = { params.openModal() },
                shape = RoundedCornerShape(8.dp),
                contentPadding = PaddingValues(horizontal = 8.dp, vertical = 0.dp),
                modifier = Modifier
                    .align(Alignment.BottomEnd)
                    .testTag("$id-preview-button")
                    .padding(bottom = 12.dp, end = 16.dp)
            ) {
                val text = "More" + when (val size = params.value.size - 1) {
                    0 -> ""
                    else -> " +$size"
                }
                Icon(Icons.Sharp.ArrowCircleRight, "more")
                Text(text)
            }
        }
    }
}