package joyfill

import androidx.compose.foundation.layout.PaddingValues
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.height
import androidx.compose.foundation.lazy.LazyColumn
import androidx.compose.foundation.lazy.items
import androidx.compose.runtime.Composable
import androidx.compose.runtime.LaunchedEffect
import androidx.compose.runtime.remember
import androidx.compose.ui.Modifier
import androidx.compose.ui.unit.dp
import cinematic.watchAsState
import joyfill.editors.BarcodeFieldEditor
import joyfill.editors.BlockFieldEditor
import joyfill.editors.ChartFieldEditor
import joyfill.editors.DateFieldEditor
import joyfill.editors.DocumentEditor
import joyfill.editors.DropdownFieldEditor
import joyfill.editors.FieldEditor
import joyfill.editors.ImageFieldEditor
import joyfill.editors.MultiSelectFieldEditor
import joyfill.editors.NumberFieldEditor
import joyfill.editors.RichTextFieldEditor
import joyfill.editors.SignatureFieldEditor
import joyfill.editors.TableFieldEditor
import joyfill.editors.TextAreaFieldEditor
import joyfill.editors.TextFieldEditor
import joyfill.image.JoyImageField
import joyfill.table.JoyTableField

@Deprecated(
    message = "This legacy component is deprecated. Use Form from the non-legacy compose module (v2).",
    level = DeprecationLevel.WARNING
)
@Composable
fun Form(
    editor: DocumentEditor,
    mode: Mode = Mode.fill,
    onUpload: (suspend (FieldEvent) -> List<String>)? = null,
    onCapture: (suspend (FieldEvent) -> String?)? = null,
    pageId: String? = null,
    navigation: Boolean = true,
    onBlur: ((event: FieldEvent) -> Unit)? = null,
    onFocus: ((event: FieldEvent) -> Unit)? = null,
    onFieldChange: ((event: FieldEvent) -> Unit)? = null,
    showUnsupportedFields: Boolean = false,
    showUnsupportedColumns: Boolean = true,
    modifier: Modifier = Modifier,
    contentPadding: PaddingValues = PaddingValues(0.dp),
) {

    val navigator = editor.pages

    LaunchedEffect(pageId) { navigator.navigate(pageId) }

    val pages = navigator.state.watchAsState()

    val page = pages.page

    val fields = remember(editor.fields, page.id) { editor.fields.from(page.id) }

    fun <T> FieldEditor.emit(signal: Signal<T>) = when (signal) {
        is Signal.Focus -> onFocus?.invoke(FieldEvent(field, page))
        is Signal.Blur -> onBlur?.invoke(FieldEvent(field, page))
        is Signal.Change -> onFieldChange?.invoke(FieldEvent(field, page))
    }

    LazyColumn(modifier = modifier, contentPadding = contentPadding) {
        if (navigation) item {
            JoyPageSelector(
                state = pages,
                onChange = { navigator.navigate(it) },
            )
        }

        items(fields, key = { it.id }) {
            when (it) {
                is TextFieldEditor -> JoyTextField(
                    editor = it,
                    mode = mode,
                    onSignal = it::emit,
                )

                is NumberFieldEditor -> JoyNumberField(
                    editor = it,
                    mode = mode,
                    onSignal = it::emit
                )

                is DateFieldEditor -> JoyDateTimeField(
                    editor = it,
                    mode = mode,
                    format = page.positions.firstOrNull { pos -> pos.field == it.id }?.format ?: it.field.format,
                    onSignal = it::emit
                )

                is MultiSelectFieldEditor -> JoySelectField(
                    editor = it,
                    mode = mode,
                    onSignal = it::emit
                )

                is DropdownFieldEditor -> JoyDropField(
                    editor = it,
                    mode = mode,
                    multiple = false,
                    onSignal = it::emit
                )

                is ImageFieldEditor -> JoyImageField(
                    editor = it,
                    mode = mode,
                    onUpload = onUpload?.let { call -> { call(FieldEvent(it.field, page)) } },
                    onSignal = it::emit
                )

                is SignatureFieldEditor -> JoySignatureField(
                    editor = it,
                    mode = mode,
                    onSignal = it::emit
                )

                is TableFieldEditor -> JoyTableField(
                    editor = it,
                    mode = mode,
                    page = page,
                    onUpload = onUpload,
                    onCapture = onCapture,
                    showUnsupportedColumns = showUnsupportedColumns,
                    previewRows = 5,
                )

                is TextAreaFieldEditor -> JoyTextArea(
                    editor = it,
                    mode = mode,
                    onSignal = it::emit
                )

                is ChartFieldEditor -> JoyChartField(
                    editor = it,
                    mode = mode,
                    onSignal = it::emit
                )

                is BlockFieldEditor -> JoyBlockField(
                    editor = it,
                    position = page.positions.find { pos -> pos.field == it.id }
                )

                is BarcodeFieldEditor -> JoyBarcodeField(
                    page = page,
                    editor = it,
                    mode = mode,
                    onCapture = onCapture,
                )

                is RichTextFieldEditor -> JoyRichTextField(it)

                else -> JoylessField(
                    field = it.field,
                    showUnsupportedFields = showUnsupportedFields
                )
            }
            if (!it.hidden.value) Spacer(modifier = Modifier.height(8.dp))
        }
    }
}