package joyfill.chart

import joyfill.IdentityGenerator
import joyfill.fields.chart.Point
import joyfill.toPoint
import joyfill.utils.ID

@PublishedApi
internal class PointBuilderImpl(
    private val identity: IdentityGenerator
) : PointBuilder {
    val points = mutableListOf<Point>()
    override fun invoke(x: Number, y: Number, label: String?) {
        val point = mutableMapOf<String, Any?>(
            ID to identity.generate(),
            Point::label.name to (label ?: "Point ${points.size}"),
            Point::x.name to x,
            Point::y.name to y
        ).toPoint()
        points.add(point)
    }
}