package joyfill

import joyfill.fields.DateField
import joyfill.fields.DropdownField
import joyfill.fields.Field
import joyfill.fields.Field.Type.barcode
import joyfill.fields.Field.Type.chart
import joyfill.fields.Field.Type.date
import joyfill.fields.Field.Type.dropdown
import joyfill.fields.Field.Type.file
import joyfill.fields.Field.Type.image
import joyfill.fields.Field.Type.multiSelect
import joyfill.fields.Field.Type.number
import joyfill.fields.Field.Type.signature
import joyfill.fields.Field.Type.table
import joyfill.fields.Field.Type.text
import joyfill.fields.Field.Type.textarea
import joyfill.fields.MultiSelectField
import joyfill.fields.TableField
import joyfill.fields.ValueBasedField
import joyfill.fields.chart.Axis
import joyfill.fields.chart.Line
import joyfill.fields.table.Column
import joyfill.fields.table.ColumnPosition
import joyfill.fields.table.Row
import joyfill.utils.AXIS_X_MAX
import joyfill.utils.AXIS_X_MIN
import joyfill.utils.AXIS_X_TITLE
import joyfill.utils.AXIS_Y_MAX
import joyfill.utils.AXIS_Y_MIN
import joyfill.utils.AXIS_Y_TITLE
import joyfill.utils.Attachment
import joyfill.utils.COLUMNS
import joyfill.utils.COLUMN_ORDER
import joyfill.utils.ID
import joyfill.utils.Option2
import joyfill.utils.POSITIONS
import joyfill.utils.TIP_DESCRIPTION
import joyfill.utils.TIP_TITLE
import joyfill.utils.TIP_VISIBLE

internal fun Page(
    id: String,
    name: String,
    hidden: Boolean,
    positions: MutableList<FieldPosition>,
    logic: MutableMap<String, Any?>?
): MutablePage = mutableMapOf(
    ID to id,
    Page::name.name to name,
    Page::hidden.name to hidden,
    POSITIONS to positions,
    Page::logic.name to logic
).toPage().toMutablePage()

internal fun File(
    id: String,
    name: String,
    pages: MutableList<Page>,
    pageOrder: MutableList<String>,
): MutableFile = mutableMapOf<String, Any?>(
    ID to id,
    File::name.name to name,
    File::pages.name to pages,
    File::pageOrder.name to pageOrder
).toFile().toMutableFile()

internal fun FieldPosition(
    id: String,
    field: String,
    displayType: String?,
    format: String?,
    columns: List<ColumnPosition>
): FieldPosition = mutableMapOf<String, Any?>(
    ID to id,
    FieldPosition::field.name to field,
    FieldPosition::displayType.name to displayType,
    FieldPosition::format.name to format,
    COLUMNS to columns.map { it.toMap() }.toMutableList(),
).toPosition()

private fun <V> ValueBasedField(
    id: String,
    title: String,
    identifier: String,
    type: Field.Type,
    readonly: Boolean,
    hidden: Boolean,
    required: Boolean,
    tip: ToolTip,
    value: V?,
    logic: MutableMap<String, Any?>?
) = mutableMapOf(
    ID to id,
    Field::title.name to title,
    Field::identifier.name to identifier,
    ValueBasedField<*>::value.name to value,
    Field::hidden.name to hidden,
    Field::disabled.name to readonly,
    Field::required.name to required,
    Field::type.name to type.name,
    TIP_TITLE to tip.title,
    TIP_DESCRIPTION to tip.description,
    TIP_VISIBLE to tip.visible,
    Field::logic.name to logic
)

internal fun TextField(
    id: String,
    title: String,
    identifier: String,
    readonly: Boolean,
    hidden: Boolean,
    required: Boolean,
    tip: ToolTip,
    value: String?,
    logic: MutableMap<String, Any?>?
) = ValueBasedField(id, title, identifier, text, readonly, hidden, required, tip, value, logic).toTextField()


internal fun TextLabel(
    id: String,
    title: String,
    identifier: String,
    hidden: Boolean,
    required: Boolean,
    tip: ToolTip,
    value: String?,
    logic: MutableMap<String, Any?>?
) = ValueBasedField(id, title, identifier, text, true, hidden, required, tip, value, logic).toTextField()

internal fun TextArea(
    id: String,
    title: String,
    identifier: String,
    readonly: Boolean,
    hidden: Boolean,
    required: Boolean,
    tip: ToolTip,
    value: String?,
    logic: MutableMap<String, Any?>?
) = ValueBasedField(id, title, identifier, textarea, readonly, hidden, required, tip, value, logic).toTextAreaField()

internal fun SignatureField(
    id: String,
    title: String,
    identifier: String,
    readonly: Boolean,
    hidden: Boolean,
    required: Boolean,
    tip: ToolTip,
    value: String?,
    logic: MutableMap<String, Any?>?
) = ValueBasedField(id, title, identifier, signature, readonly, hidden, required, tip, value, logic).toSignatureField()

internal fun NumberField(
    id: String,
    title: String,
    identifier: String,
    readonly: Boolean,
    hidden: Boolean,
    required: Boolean,
    tip: ToolTip,
    value: Number?,
    logic: MutableMap<String, Any?>?
) = ValueBasedField(id, title, identifier, number, readonly, hidden, required, tip, value?.toDouble(), logic).toNumberField()

internal fun DateField(
    id: String,
    title: String,
    identifier: String,
    readonly: Boolean,
    hidden: Boolean,
    required: Boolean,
    format: String?,
    tip: ToolTip,
    value: Long?,
    logic: MutableMap<String, Any?>?
) = mutableMapOf<String, Any?>(
    ID to id,
    Field::title.name to title,
    Field::identifier.name to identifier,
    ValueBasedField<*>::value.name to value,
    Field::disabled.name to readonly,
    DateField::format.name to format,
    Field::hidden.name to hidden,
    Field::required.name to required,
    TIP_TITLE to tip.title,
    TIP_DESCRIPTION to tip.description,
    TIP_VISIBLE to tip.visible,
    Field::type.name to date.name,
    Field::logic.name to logic
).toDateField()

internal fun DropdownField(
    id: String,
    title: String,
    identifier: String,
    options: List<Option2>,
    readonly: Boolean,
    hidden: Boolean,
    required: Boolean,
    selected: Option2?,
    logic: MutableMap<String, Any?>?
) = mutableMapOf(
    ID to id,
    Field::title.name to title,
    Field::identifier.name to identifier,
    ValueBasedField<*>::value.name to selected?.value,
    DropdownField::options.name to options.map { it.toMap() }.toMutableList(),
    Field::disabled.name to readonly,
    Field::hidden.name to hidden,
    Field::required.name to required,
    Field::type.name to dropdown.name,
    Field::logic.name to logic
).toDropdownField()

internal fun MultiSelectField(
    id: String,
    title: String,
    multi: Boolean,
    identifier: String,
    options: List<Option2>,
    hidden: Boolean,
    required: Boolean,
    tip: ToolTip,
    selected: List<String>,
    logic: MutableMap<String, Any?>?
) = mutableMapOf<String, Any?>(
    ID to id,
    Field::title.name to title,
    Field::identifier.name to identifier,
    MultiSelectField::multi.name to multi,
    ValueBasedField<*>::value.name to selected,
    DropdownField::options.name to options.map { it.toMap() }.toMutableList(),
    TIP_TITLE to tip.title,
    TIP_DESCRIPTION to tip.description,
    TIP_VISIBLE to tip.visible,
    Field::hidden.name to hidden,
    Field::required.name to required,
    Field::type.name to multiSelect.name,
    Field::logic.name to logic
).toMultiSelectField()

internal fun FileField(
    id: String,
    title: String,
    identifier: String,
    readonly: Boolean,
    hidden: Boolean,
    required: Boolean,
    tip: ToolTip,
    value: List<Attachment>
) = mutableMapOf<String, Any?>(
    ID to id,
    Field::title.name to title,
    Field::identifier.name to identifier,
    ValueBasedField<*>::value.name to value,
    Field::disabled.name to readonly,
    Field::hidden.name to hidden,
    Field::required.name to required,
    TIP_TITLE to tip.title,
    TIP_DESCRIPTION to tip.description,
    TIP_VISIBLE to tip.visible,
    Field::type.name to file.name
).toFileField()

internal fun ImageField(
    id: String,
    title: String,
    identifier: String,
    readonly: Boolean,
    hidden: Boolean,
    required: Boolean,
    tip: ToolTip,
    value: List<Attachment>
) = mutableMapOf<String, Any?>(
    ID to id,
    Field::title.name to title,
    Field::identifier.name to identifier,
    ValueBasedField<*>::value.name to value.map { it.toMap() }.toMutableList(),
    Field::hidden.name to hidden,
    Field::required.name to required,
    Field::disabled.name to readonly,
    TIP_TITLE to tip.title,
    TIP_DESCRIPTION to tip.description,
    TIP_VISIBLE to tip.visible,
    Field::type.name to image.name
).toImageField()


internal fun BarcodeField(
    id: String,
    title: String,
    identifier: String,
    readonly: Boolean,
    hidden: Boolean,
    required: Boolean,
    tip: ToolTip,
    value: String?,
    logic: MutableMap<String, Any?>?
) = ValueBasedField(id, title, identifier, barcode, readonly, hidden, required, tip, value, logic).toBarcodeField()



internal fun TableField(
    id: String,
    title: String,
    identifier: String,
    columns: List<Column>
) = mutableMapOf<String, Any?>(
    ID to id,
    Field::title.name to title,
    Field::identifier.name to identifier,
    ValueBasedField<*>::value.name to mutableListOf<Row>(),
    Field::type.name to table.name,
    COLUMNS to columns.map { it.toMap() }.toMutableList(),
    COLUMN_ORDER to columns.map { it.id }.toMutableList(),
    TableField::rowOrder.name to mutableListOf<String>()
).toTableField()

internal fun ChartField(
    id: String,
    title: String,
    identifier: String,
    y: Axis,
    x: Axis,
    lines: List<Line>
) = mutableMapOf<String, Any?>(
    ID to id,
    Field::title.name to title,
    Field::identifier.name to identifier,
    AXIS_Y_TITLE to y.label,
    AXIS_Y_MIN to y.min,
    AXIS_Y_MAX to y.max,
    AXIS_X_TITLE to x.label,
    AXIS_X_MIN to x.min,
    AXIS_X_MAX to x.max,
    ValueBasedField<*>::value.name to lines.map { it.toMap() }.toMutableList(),
    Field::type.name to chart.name,
).toChartField()

internal fun UnknownField(
    id: String,
    title: String,
    identifier: String,
    type: Field.Type
) = mutableMapOf<String, Any?>(
    ID to id,
    Field::title.name to title,
    Field::identifier.name to identifier,
    Field::type.name to type.name,
).toUnknownField()