package joyfill.internal

import joyfill.ConditionsBuilder
import joyfill.LogicBuilder

internal class LogicBuilderImpl : LogicBuilder {
    var logic: MutableMap<String, Any?>? = null
    override fun showWhenAll(builder: ConditionsBuilder.() -> Unit) = show("and", builder)

    override fun showWhenAny(builder: ConditionsBuilder.() -> Unit) = show("or", builder)

    override fun hideWhenAll(builder: ConditionsBuilder.() -> Unit) = hide("and", builder)

    override fun hideWhenAny(builder: ConditionsBuilder.() -> Unit) = hide("or", builder)

    private fun logic(action: String, eval: String, builder: ConditionsBuilder.() -> Unit) {
        val conditions = ConditionsBuilderImpl().apply { builder() }.conditions
        logic = mutableMapOf()
        logic?.put("action", action)
        logic?.put("eval", eval)
        logic?.put("conditions", conditions)
    }

    private fun show(eval: String, builder: ConditionsBuilder.() -> Unit) = logic("show", eval, builder)
    private fun hide(eval: String, builder: ConditionsBuilder.() -> Unit) = logic("hide", eval, builder)
}