package joyfill.internal

import joyfill.ConditionBuilder
import joyfill.conditions.Condition

internal class ConditionBuilderImpl(
    private val conditions: MutableList<MutableMap<String, Any?>>,
    val field: String
) : ConditionBuilder {
    override fun isFilled() = Condition.Filled.build()

    override fun isEmpty() = Condition.Empty.build()

    override fun isEqualTo(value: Any) = Condition.Equals.build("value" to value)

    override fun isNotEqualTo(value: Any) = Condition.NotEquals.build("value" to value)

    override fun isContaining(value: String) = Condition.Contains.build("value" to value)

    override fun isGreaterThan(value: Number) = Condition.GreaterThan.build("value" to value)

    override fun isLessThan(value: Number) = Condition.LessThan.build("value" to value)

    private fun Condition.build(vararg pairs: Pair<String, Any?>) {
        val c = mutableMapOf<String, Any?>()
        c["field"] = field
        c["condition"] = notation
        for ((k, v) in pairs) c[k] = v
        conditions.add(c)
    }
}