package joyfill.table

import joyfill.LogicBuilder
import joyfill.ToolTip

interface ColumnBuilder {
    fun text(
        title: String = "Text Column",
        id: String? = null,
        required: Boolean? = false,
        value: String? = null,
        hidden: Boolean = false
    )

    fun block(
        title: String = "Block Column",
        id: String? = null,
        value: String? = null,
        hidden: Boolean = false
    )

    fun date(
        title: String = "Date Column",
        id: String? = null,
        identifier: String? = null,
        format: String? = null,
        readonly: Boolean = false,
        hidden: Boolean = false,
        required: Boolean = false,
        tip: ToolTip = ToolTip(""),
        value: Long? = null,
        logic: (LogicBuilder.() -> Unit)? = null
    )

    fun number(
        title: String = "Number Column",
        id: String? = null,
        required: Boolean? = false,
        value: Double? = null,
        hidden: Boolean = false
    )

    fun dropdown(
        title: String = "Dropdown Column",
        options: List<String> = emptyList(),
        id: String? = null,
        required: Boolean? = false,
        value: String? = null,
        hidden: Boolean = false
    )

    fun multiselect(
        title: String = "Multiselect Column",
        options: Map<String, String?> = emptyMap(),
        multi: Boolean = true,
        id: String? = null,
        required: Boolean? = false,
        value : List<String> = emptyList(),
        hidden: Boolean = false
    )

    fun image(
        title: String = "Image Column",
        id: String? = null,
        identifier: String? = null,
        required: Boolean? = false,
        value: List<String> = emptyList(),
        hidden: Boolean = false
    )

    fun barcode(
        title: String = "Barcode Column",
        id: String? = null,
        required: Boolean? = false,
        value: String? = null,
        hidden: Boolean = false
    )
    fun signature(
        title: String = "Signature",
        id: String? = null,
        identifier: String? = null,
        readonly: Boolean = false,
        hidden: Boolean = false,
        required: Boolean = false,
        tip: ToolTip = ToolTip(""),
        value: String? = null,
    )

    fun progress(
        title: String = "Progress Column",
        id: String? = null,
        value: String? = null,
        hidden: Boolean = false
    )

    fun unknown(
        title: String = "Unknown",
        id: String? = null,
        required: Boolean? = false,
        identifier: String? = null
    )
}