package joyfill

import joyfill.chart.LineBuilder
import joyfill.chart.LineBuilderImpl
import joyfill.fields.Field
import joyfill.fields.chart.Line
import joyfill.internal.DocumentBuilderImpl
import joyfill.utils.ID

@Deprecated(
    message = "This legacy builder is deprecated. Use buildDocument from the non-legacy builder module (v2).",
    level = DeprecationLevel.WARNING
)
fun buildDocument(
    identity: IdentityGenerator = IdentityGenerator.default,
    builder: DocumentBuilder.() -> Unit,
): Document {
    val uid = identity.generate()
    val document = mutableMapOf<String, Any?>(
        ID to uid,
        Document::identifier.name to "document-$uid",
        Document::name.name to "New Document",
        Document::files.name to mutableListOf<File>(),
        Document::fields.name to mutableListOf<Field>()
    ).toDocument().toMutableDocument()
    val db = DocumentBuilderImpl(document, identity)
    db.builder()
    return db.document
}

fun plot(
    identity: IdentityGenerator = IdentityGenerator.default,
    builder: LineBuilder.() -> Unit,
): List<Line> = LineBuilderImpl(identity).apply(builder).lines