package joyfill

import joyfill.chart.LineBuilder
import joyfill.fields.chart.Axis
import joyfill.fields.chart.Line
import joyfill.table.ColumnBuilder

interface DocumentBuilder {
    fun name(value: String)

    fun page(
        name: String?,
        hidden: Boolean = false,
        logic: (LogicBuilder.() -> Unit)? = null
    ): Page

    fun text(
        title: String = "Text Field",
        id: String? = null,
        identifier: String? = null,
        readonly: Boolean = false,
        hidden: Boolean = false,
        required: Boolean = false,
        tip: ToolTip = ToolTip(""),
        value: String? = null,
        logic: (LogicBuilder.() -> Unit)? = null
    )

    fun block(
        title: String = "Block Field",
        id: String? = null,
        identifier: String? = null,
        hidden: Boolean = false,
        required: Boolean = false,
        tip: ToolTip = ToolTip(""),
        value: String? = null,
        logic: (LogicBuilder.() -> Unit)? = null
    )

    fun textarea(
        title: String = "Text Area",
        id: String? = null,
        identifier: String? = null,
        readonly: Boolean = false,
        hidden: Boolean = false,
        required: Boolean = false,
        tip: ToolTip = ToolTip(""),
        value: String? = null,
        logic: (LogicBuilder.() -> Unit)? = null
    )

    fun signature(
        title: String = "Signature",
        id: String? = null,
        identifier: String? = null,
        readonly: Boolean = false,
        hidden: Boolean = false,
        required: Boolean = false,
        tip: ToolTip = ToolTip(""),
        value: String? = null,
        logic: (LogicBuilder.() -> Unit)? = null
    )

    fun number(
        title: String = "Number Field",
        id: String? = null,
        identifier: String? = null,
        readonly: Boolean = false,
        hidden: Boolean = false,
        required: Boolean = false,
        tip: ToolTip = ToolTip(""),
        value: Number? = null,
        logic: (LogicBuilder.() -> Unit)? = null
    )

    fun date(
        title: String = "Date Field",
        id: String? = null,
        identifier: String? = null,
        format: String? = null,
        readonly: Boolean = false,
        hidden: Boolean = false,
        required: Boolean = false,
        tip: ToolTip = ToolTip(""),
        value: Long? = null,
        logic: (LogicBuilder.() -> Unit)? = null
    )

    fun dropdown(
        title: String = "Dropdown Field",
        options: List<String>,
        id: String? = null,
        identifier: String? = null,
        readonly: Boolean = false,
        hidden: Boolean = false,
        required: Boolean = false,
        tip: ToolTip = ToolTip(""),
        value: String? = null,
        logic: (LogicBuilder.() -> Unit)? = null
    )

    fun select(
        title: String = "Select Field",
        options: List<String>,
        multi: Boolean = true,
        id: String? = null,
        identifier: String? = null,
        readonly: Boolean = false,
        hidden: Boolean = false,
        required: Boolean = false,
        tip: ToolTip = ToolTip(""),
        value: List<String> = emptyList(),
        logic: (LogicBuilder.() -> Unit)? = null
    )

    fun select(
        title: String = "Select Field",
        options: List<String>,
        multi: Boolean = true,
        id: String? = null,
        identifier: String? = null,
        readonly: Boolean = false,
        hidden: Boolean = false,
        required: Boolean = false,
        tip: ToolTip = ToolTip(""),
        value: String,
        logic: (LogicBuilder.() -> Unit)? = null
    )

    fun image(
        title: String = "Image Field",
        id: String? = null,
        identifier: String? = null,
        readonly: Boolean = false,
        hidden: Boolean = false,
        required: Boolean = false,
        tip: ToolTip = ToolTip(""),
        value: List<String> = emptyList(),
        logic: (LogicBuilder.() -> Unit)? = null
    )

    fun barcode(
        title: String = "Barcode Field",
        id: String? = null,
        identifier: String? = null,
        readonly: Boolean = false,
        hidden: Boolean = false,
        required: Boolean = false,
        tip: ToolTip = ToolTip(""),
        value: String? = null,
        logic: (LogicBuilder.() -> Unit)? = null
    )

    fun image(
        title: String = "Image Field",
        id: String? = null,
        identifier: String? = null,
        readonly: Boolean = false,
        hidden: Boolean = false,
        required: Boolean = false,
        tip: ToolTip = ToolTip(""),
        value: String,
        logic: (LogicBuilder.() -> Unit)? = null
    )

    fun file(
        title: String = "File Field",
        id: String? = null,
        identifier: String? = null,
        readonly: Boolean = false,
        hidden: Boolean = false,
        required: Boolean = false,
        tip: ToolTip = ToolTip(""),
        value: List<String> = emptyList(),
        logic: (LogicBuilder.() -> Unit)? = null
    )

    fun table(
        title: String = "Table Field",
        id: String? = null,
        identifier: String? = null,
        readonly: Boolean = false,
        hidden: Boolean = false,
        tip: ToolTip = ToolTip(""),
        logic: (LogicBuilder.() -> Unit)? = null,
        columns: (ColumnBuilder.() -> Unit)? = null
    )

    fun chart(
        title: String = "Chart Field",
        y: Axis = Axis("Y-Axis"),
        x: Axis = Axis("X-Axis"),
        id: String? = null,
        identifier: String? = null,
        readonly: Boolean = false,
        hidden: Boolean = false,
        tip: ToolTip = ToolTip(""),
        logic: (LogicBuilder.() -> Unit)? = null,
        lines: (LineBuilder.() -> Unit)? = null
    )

    fun chart(
        title: String = "Chart Field",
        y: Axis = Axis("Y-Axis"),
        x: Axis = Axis("X-Axis"),
        id: String? = null,
        identifier: String? = null,
        readonly: Boolean = false,
        hidden: Boolean = false,
        lines: List<Line>,
        tip: ToolTip = ToolTip(""),
        logic: (LogicBuilder.() -> Unit)? = null,
    )


    fun unknown(
        title: String,
        id: String? = null,
        identifier: String? = null,
        hidden: Boolean = false,
        tip: ToolTip = ToolTip("")
    )
}