package joyfill.internal

import joyfill.User
import joyfill.UserType
import joyfill.UsersApi
import joyfill.internal.config.ApiConfig
import joyfill.response.decodeJoyListResponse
import koncurrent.Later
import koncurrent.coroutines.asCoroutineScope
import koncurrent.later

internal class UsersApiImpl(config: ApiConfig) : AbstractJoyfillApi(config), UsersApi {

    private val scope by lazy { config.executor.asCoroutineScope() }
    override fun list(limit: Int, page: Int, type: UserType, group: String?): Later<List<User>> = scope.later {
        if (limit !in 1..100) throw IllegalArgumentException("limit must be between 1 and 100")
        val json = mapOf(
            "limit" to limit,
            "page" to page,
            "type" to type,
            "group" to group
        ).joyGet("users")

        config.codec.decodeJoyListResponse(json)
    }
}