package joyfill.response

import kotlinx.serialization.StringFormat
import kotlinx.serialization.builtins.ListSerializer
import kotlinx.serialization.serializer

inline fun <reified T> StringFormat.decodeJoyfillResponse(json: String): T = try {
    decodeFromString<SuccessResponse<T>>(SuccessResponse.serializer(serializer()), json).data
} catch (err: Throwable) {
    throw try {
        decodeFromString(FailureResponse.serializer(), json).toException()
    } catch (err2: Throwable) {
        err
    }
}

inline fun <reified T> StringFormat.decodeJoyListResponse(json: String): List<T> = try {
    decodeFromString(SuccessResponse.serializer(ListSerializer(serializer<T>())), json).data
} catch (err: Throwable) {
    throw try {
        decodeFromString(FailureResponse.serializer(), json).toException()
    } catch (err2: Throwable) {
        err
    }
}