@file:OptIn(ExperimentalEncodingApi::class)

package joyfill.internal.config

import io.ktor.client.HttpClient
import io.ktor.utils.io.core.toByteArray
import koncurrent.Executor
import kotlin.io.encoding.Base64
import kotlin.io.encoding.ExperimentalEncodingApi
import kotlinx.serialization.StringFormat

data class ApiKeyConfig(
    override val url: String,
    override val version: String,
    override val executor: Executor,
    override val http: HttpClient,
    override val codec: StringFormat,
    val publicKey: String,
    val secretKey: String
) : ApiConfig {
    override val authorizationHeader by lazy {
        "Basic ${Base64.encode("$publicKey:$secretKey".toByteArray())}"
    }
}