package joyfill.internal.config

import io.ktor.client.HttpClient
import koncurrent.Executor
import kotlinx.serialization.StringFormat

data class AccessTokenConfig(
    override val url: String,
    override val version: String,
    override val executor: Executor,
    override val http: HttpClient,
    override val codec: StringFormat,
    val token: String
) : ApiConfig {
    override val authorizationHeader by lazy {
        "Bearer $token"
    }
}