package joyfill.internal

import joyfill.Group
import joyfill.GroupsApi
import joyfill.internal.config.ApiConfig
import joyfill.response.decodeJoyListResponse
import koncurrent.Later
import koncurrent.coroutines.asCoroutineScope
import koncurrent.later
import kotlinx.serialization.decodeFromString

@PublishedApi
internal class GroupsApiImpl(config: ApiConfig) : AbstractJoyfillApi(config), GroupsApi {

    private val scope by lazy { config.executor.asCoroutineScope() }

    override fun create(title: String): Later<Group> = createGroup(null, title)
    override fun create(identifier: String, title: String): Later<Group> = createGroup(identifier, title)

    private fun createGroup(identifier: String?, title: String): Later<Group> = scope.later {
        val json = buildMap {
            put("title", title)
            if (identifier != null) {
                put("identifier", identifier)
            }
        }.joyPost("groups")
        println(json)
        config.codec.decodeFromString(json)
    }

    override fun list(limit: Int, page: Int): Later<List<Group>> = scope.later {
        if (limit !in 1..100) throw IllegalArgumentException("limit must be between 1 and 100")
        val json = mapOf("limit" to limit, "page" to page).joyGet("groups")
        println(json)
        config.codec.decodeJoyListResponse(json)
    }
}