package joyfill.response

import joyfill.BadRequestException
import joyfill.UnknownException
import kotlinx.serialization.Serializable

@Serializable
data class FailureResponse(
    val statusCode: Int,
    val error: String,
    val message: String
) {
    fun toException() = when (error) {
        "Bad Request" -> BadRequestException(statusCode, message)
        else -> UnknownException(message)
    }
}